package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TareaAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * TareaAperturasService generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaAperturasService {

	/**
	 * Inserts a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas add(TareaAperturas tareaAperturas);

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas update(TareaAperturas tareaAperturas);

	/**
	 * Updates a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TareaAperturas updateFilled(TareaAperturas tareaAperturas);

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	TareaAperturas find(TareaAperturas tareaAperturas);

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @return the tarea aperturas
	 */
	public TareaAperturas findTareaTramite(TareaAperturas tareaAperturas);

	/**
	 * Finds a single row in the TareaAperturas table.
	 * 
	 *  mailboxTaskId
	 *            String
	 *  TareaAperturas
	 *
	 * @param mailboxTaskId the mailbox task id
	 * @return the tarea aperturas
	 */
	public TareaAperturas findByMailboxTaskId(String mailboxTaskId);

	/**
	 * Deletes a single row in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *
	 * @param tareaAperturas the tarea aperturas
	 */
	void remove(TareaAperturas tareaAperturas);

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TareaAperturas> findAll(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds a list of rows in the TareaAperturas table.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<TareaAperturas> findAllTareatramite(
			TareaAperturas tareaAperturas, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the TareaAperturas table using like.
	 * 
	 *  tareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TareaAperturas>
	 *
	 * @param tareaAperturas the tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TareaAperturas> findAllLike(TareaAperturas tareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<TareaAperturas>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<TareaAperturas> filter(
			TareaAperturas filterTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  searchTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<TareaAperturas>>
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param searchTareaAperturas the search tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<TareaAperturas>> search(
			TareaAperturas filterTareaAperturas,
			TareaAperturas searchTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder the selection made in TareaAperturas table.
	 * 
	 *  filterTareaAperturas
	 *            TareaAperturas
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterTareaAperturas the filter tarea aperturas
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	Object reorderSelection(TareaAperturas filterTareaAperturas,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

}
